  % You  can use the code freely, please cite the following artical:
  % Ming Li, Xue Mei Song, Tao Xu, et al., Subdomains within orientation columns of primary visual cortex, Science Advances,  Volume 5(6):eaaw0807, 2019, DOI: 10.1126/sciadv.aaw0807

function NSIScore = NSI_Calculate(varargin)

if isempty(varargin)
    UDtemp = get(gcf,'Userdata');
    x = UDtemp.x;
    y = UDtemp.y;       
else
    x = varargin{1};
    y = varargin{2};
    z = varargin{3};

end
y1 = y(1:length(y)/2)-y(1+length(y)/2:length(y));
yOrg = y;

[temp1 temp2] = max(y);

a0(1) = (max(y) - min(y))/2 ;
a0(2) = 3.14/2 - x(temp2)/180*3.14*2;
a0(3) = mean(y);
 
options=optimset('fminsearch');
options.ToIX=0.00001;
options.Display='off';
a_o=fminsearch(@mySinFunE,a0,options,x,y);
xx = 0:180;
yy = a_o(1)*sin(xx/180*3.14*2+a_o(2))+a_o(3);
yyo = yy;

Eo = mySinFunE(a_o,x,y);


[tt pms] = sort(rand(1000,length(x)),2);
    for j = 1:size(pms,1)
        y = yOrg(pms(j,:));
        a0(1) = (max(y) - min(y))/2 ;
        a0(2) = 3.14/2 - x(temp2)/180*3.14*2;
        a0(3) = mean(y);
        a=fminsearch(@mySinFunE,a0,options,x,y);
        Eall(j) = mySinFunE(a,x,y);
        display(['Caculating',num2str(j)]);
    end
    NSIScore = sum(Eall-Eo<=0)/size(pms,1)

    subplot(1,2,1)
    hold on
    plot(xx,yy,'r');
    h = text(15,0,['NSI=',num2str(NSIScore)]);
    set(h,'EraseMode','XOr','FontWeight','bold','FontSize',15);
end

            